SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_recomputequotacounters]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_recomputequotacounters]
GO

CREATE PROCEDURE  [dbo].[Sp_recomputequotacounters]
    @projectId INT,
    @UserId    INT,
    @ImportWave INT = null
AS
  DECLARE  @replicate BIT

  SELECT @replicate = insvalue
  FROM   Installation
  WHERE  insident = 'QUOTASMODEREPLICATE'

  IF @replicate = 1
  BEGIN
    UPDATE Quota
    SET    QtUnused = Unused,
           QtFrequence = Completed,
           QtOnline = Online
    FROM   Quota INNER JOIN 
	    (SELECT QuotaId,
                 Sum(unused)    AS unused,
                 Sum(completed) AS completed,
                 Sum(online)    AS online
             FROM (SELECT QtQuotaId AS QuotaId,
                     CASE WHEN ResCall = 0 THEN 1 ELSE 0 END AS Unused,
                     CASE WHEN ResCompleted = 1 THEN 1 ELSE 0 END AS Completed,
                     CASE WHEN ResCallBackDate > 0 THEN 1 ELSE 0 END AS Online
                  FROM Quota
                       LEFT OUTER JOIN Stratum WITH (NOLOCK) ON QtQuotaId = StrQuotaId
                       LEFT OUTER JOIN respondent WITH (NOLOCK) ON StrRespondent = ResRespondent
                  WHERE  QtStratum > 0) a
             GROUP BY QuotaId) b ON QuotaId = QtQuotaId

  END
  ELSE
  BEGIN
    
    --print convert(char(23), getutcdate(), 126) + ' :    Update Quota'
    
    UPDATE quota
    SET QtUnused = isnull(unused.cnt,0),
		QtFrequence = isnull(completed.cnt,0),
		QtOnLine = 0
    FROM Quota 
    left join (SELECT StrQuotaId QuotaId, COUNT(*) cnt 
					FROM Stratum WITH(nolock) 
					inner join Respondent WITH(nolock) on StrRespondent = ResRespondent 
					WHERE ResCall = 0 
					GROUP BY StrQuotaId) unused on QtQuotaId = unused.QuotaId 
	left join (SELECT StrQuotaId QuotaId, COUNT(*) cnt 
					FROM Stratum WITH(nolock) 
					inner join Respondent WITH(nolock) on StrRespondent = ResRespondent 
					WHERE ResCompleted = 1 
					GROUP BY StrQuotaId) completed on QtQuotaId = completed.QuotaId	
    WHERE QtStratum > 0 --Exclude global quota
		
  END
    
  --print convert(char(23), getutcdate(), 126) + ' :    Update Respondent'

    UPDATE Respondent
    SET ResIntervCall = (CASE WHEN qtgroup = 0 THEN '' 
							  WHEN qtgroup < 10 THEN 'G0' + Cast(qtgroup AS VARCHAR) 
							  ELSE 'G' + Cast(qtgroup AS VARCHAR) END) 
    FROM Respondent 
    inner join (SELECT StrRespondent as respondent, MAX(qtgroup) qtgroup 
						FROM Stratum WITH (NOLOCK) 
						inner join Quota WITH (NOLOCK) on StrQuotaid = QtQuotaId 
						GROUP BY StrRespondent) qt on ResRespondent = qt.respondent
    WHERE ResCall = 0
    and (@importWave is null or @ImportWave = ResWaveImportNo)
    and (ResIntervCall = '' OR ResIntervCall = '***' OR ResIntervCall LIKE 'G[0-9][0-9]')
    and ResIntervCall <> (CASE WHEN qtgroup = 0  THEN '' 
							   WHEN qtgroup < 10 THEN 'G0' + Cast(qtgroup AS VARCHAR) 
							   ELSE 'G' + Cast(qtgroup AS VARCHAR) END)
  
  --print convert(char(23), getutcdate(), 126) + ' :    Update Quota #2'         

  UPDATE quota
  SET QtUnused = (SELECT Count(resrespondent) FROM Respondent WITH (NOLOCK) WHERE ResCall = 0),
      QtFrequence = (SELECT Count(resrespondent) FROM Respondent WITH (NOLOCK) WHERE  rescompleted = 1)
  WHERE QtStratum = 0
  
  --Update frequency for quotasagent (CAPI)
  print convert(char(23), getutcdate(), 126) + ' :    Update QuotasAgent'
  UPDATE quotasagent SET frequency=completed 
  FROM QuotasAgent inner join
    (SELECT Stratumno,interviewerid, sum(completed) as completed 
     FROM (SELECT	Stratum as Stratumno,agentid as interviewerid,
					case when rescompleted=1 then 1 else 0 end as completed 
				FROM QuotasAgent 
				left outer join quota			on  qtstratum=stratum 
				left outer join stratum			on  stratum=strstratum 
				left outer join respondent r	on  strrespondent=resrespondent 
												and IsNumeric(resintervcall)=1 
												and resintervcall=agentid) a 
     GROUP BY stratumno,interviewerid) b	on  stratum=stratumno 
											and agentid=interviewerid
GO


